from pyomo.environ import *
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import os
import pandas as pd
from matplotlib.ticker import ScalarFormatter
import matplotlib.colors as mc
import colorsys

os.chdir("C:/Users/agusv/Desktop/Estudio/Tesis/Csv")

all_scenarios = {
    "A1": {"emissions": [], "costs": []},
    "A2": {"emissions": [], "costs": []},
    "B1": {"emissions": [], "costs": []},
    "B2": {"emissions": [], "costs": []},
    "C1": {"emissions": [], "costs": []},
    "C2": {"emissions": [], "costs": []},
}


truck_type = ['Diesel_T', 'LNG_T', 'BioLNG_T', 'HVO100_T', 'Electric_T', 'Hydrogen_T']
cooler_type = ['Diesel_C', 'HVO100_C', 'Nitrogen_C','Electric_C']

truck_km = {
    'Diesel_T': 140000,
    'LNG_T': 130000,
    'BioLNG_T': 130000,
    'HVO100_T': 140000,
    'Electric_T': 70000,
    'Hydrogen_T': 100000
}

cooler_h = {
    'Diesel_C': 1896,
    'HVO100_C': 1896,
    'Nitrogen_C':1896,
    'Electric_C': 1896,
}

truck_costs = {
    'Diesel_T': 1.91,
    'LNG_T': 1.76,
    'BioLNG_T':1.8,
    'HVO100_T':1.95,
    'Electric_T':3.22,
    'Hydrogen_T':4.65
    }

cooler_costs = {
    'Diesel_C': 1.91,
    'HVO100_C':1.95,
    'Nitrogen_C': 1.875,
    'Electric_C':3.22
    }
    
truck_emissions_km = {
    "Diesel_T": 0.9956, 
    "LNG_T": 1.118,      
    "BioLNG_T": 0.209,  
    "HVO100_T": 0.3613,
    "Electric_T": 0.0874, 
    "Hydrogen_T": 0.0473 
}

cooler_emissions_h = {
    "Diesel_C": 12.744,
    "HVO100_C": 4.192,
    "Nitrogen_C": 6.072,
    "Electric_C": 0.2464
}

total_km=70000000
budget_azienda=131000000

#Scenario A1
#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so


#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       


results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

#Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler     

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    all_scenarios["A1"]["emissions"].append(total_emissions)
    all_scenarios["A1"]["costs"].append(total_cost)
    
#Scenario A2

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so, total_cost_cooler_cost_so,total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so, biolng_coefficients_cost_so= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    
    # Restricciones del modelo
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

#Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c2 = Constraint(expr=(sum(model.x[i] * truck_km[i] * truck_emissions[i] for i in truckVector) + sum(model.y[j] * cooler_h[j] * cooler_emissions[j] for j in coolerVector)) <= epsilon)

    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    all_scenarios["A2"]["emissions"].append(total_emissions)
    all_scenarios["A2"]["costs"].append(total_cost)

# Scenario B1
#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario B.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c10 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c11 = Constraint(expr=model.x['Electric_T']>=3)

# Risk management perspective: limit each truck type to < 50% of total kilometers.

    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
# Constraints for each truck type

    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c10 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c11 = Constraint(expr=model.x['Electric_T']>=3)

# Risk management perspective: limit each truck type to < 50% of total kilometers.

    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
# Constraints for each truck type

    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions


# Scenario B.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c10 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c11 = Constraint(expr=model.x['Electric_T']>=3)

# Risk management perspective: limit each truck type to < 50% of total kilometers.

    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
# Constraints for each truck type

    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler

from matplotlib.ticker import ScalarFormatter


epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    all_scenarios["B1"]["emissions"].append(total_emissions)
    all_scenarios["B1"]["costs"].append(total_cost)

#Scenario B2

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario B.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals, initialize = 0.33)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals, initialize = 0.33)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals, initialize = 0.33)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    model.c8 = Constraint(expr=model.x['Diesel_T'] <= 0)
    model.c9 = Constraint(expr=model.x['BioLNG_T'] >= 52)
    model.c10 = Constraint(expr=model.x['HVO100_T'] >= 5)
    model.c11 = Constraint(expr=model.x['Electric_T'] >= 3)
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so, total_cost_cooler_cost_so,total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so, biolng_coefficients_cost_so= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
#Model constraints
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    
#Minimum quantity of trucks based on the current truck availability of the company.

    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c10 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c11 = Constraint(expr=model.x['Electric_T']>=3)
    
#Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

# Scenario B.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c2 = Constraint(expr=(sum(model.x[i] * truck_km[i] * truck_emissions[i] for i in truckVector) + sum(model.y[j] * cooler_h[j] * cooler_emissions[j] for j in coolerVector)) <= epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])

# Minimum quantity of trucks based on the current truck availability of the company.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c10 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c11 = Constraint(expr=model.x['Electric_T']>=3)

#Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model, tee=False)
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    all_scenarios["B2"]["emissions"].append(total_emissions)
    all_scenarios["B2"]["costs"].append(total_cost)
    
# Scenario C1

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario C.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)


#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

# Scenario C.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler     


from matplotlib.ticker import ScalarFormatter
#5377006

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )

    all_scenarios["C1"]["emissions"].append(total_emissions)
    all_scenarios["C1"]["costs"].append(total_cost)

# Scenario C.2    

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario C.2


def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so, total_cost_cooler_cost_so,total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so, biolng_coefficients_cost_so= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
#Model constraints
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    
# Minimum quantity of trucks based on the current truck availability of the company.
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

# Scenario C.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])

# Minimum quantity of trucks based on the current truck availability of the company.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model, tee=False)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    all_scenarios["C2"]["emissions"].append(total_emissions)
    all_scenarios["C2"]["costs"].append(total_cost)
    

base_colors = {
    "A": "blue",
    "B": "green",
    "C": "red",
}

def adjust_lightness(color, amount=0.3):
    try:
        c = mc.cnames[color]
    except KeyError:
        c = color
    c = colorsys.rgb_to_hls(*mc.to_rgb(c))
    return colorsys.hls_to_rgb(c[0], max(0, min(1, amount * c[1])), c[2])

plt.figure(figsize=(12, 8))


for scenario, data in all_scenarios.items():
    base_color = base_colors[scenario[0]]
    lightness = 0.8 if scenario.endswith("2") else 0.3 
    color = adjust_lightness(base_color, lightness)
    

    plt.plot(data["emissions"], data["costs"], linestyle='-', color=color, label=f"Scenario {scenario}")

plt.xlabel("Total Emissions (Kg CO2e)", fontsize=20)
plt.ylabel("Total Cost (€)", fontsize=20)
plt.title("Comparison of Pareto Frontiers Across Scenarios", fontsize=20, fontweight="bold")

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.gca().xaxis.set_major_formatter(ScalarFormatter())
plt.gca().ticklabel_format(style="plain", axis="both")

plt.grid(True, linestyle="--", alpha=0.6)
plt.legend(fontsize=12)
plt.tight_layout()
plt.show()

#Total cost graph
plt.figure(figsize=(12, 8))

for scenario, data in all_scenarios.items():
    base_color = base_colors[scenario[0]]
    lightness = 0.8 if scenario.endswith("2") else 0.3
    color = adjust_lightness(base_color, lightness)
    
    plt.plot(range(len(data["costs"])), data["costs"], linestyle='-', color=color, label=f"Scenario {scenario}")

plt.xlabel("Iteration", fontsize=20)
plt.ylabel("Total Cost (€)", fontsize=20)
plt.title("Total Costs per Iteration for Each Scenario", fontsize=20, fontweight="bold")

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.grid(True, linestyle="--", alpha=0.6)
plt.legend(fontsize=12)
plt.tight_layout()
plt.show()

#Total cost graph
plt.figure(figsize=(12, 8))

for scenario, data in all_scenarios.items():
    base_color = base_colors[scenario[0]]
    lightness = 0.8 if scenario.endswith("2") else 0.3
    color = adjust_lightness(base_color, lightness)
    
    plt.plot(range(len(data["emissions"])), data["emissions"], linestyle='-', color=color, label=f"Scenario {scenario}")

plt.xlabel("Iteration", fontsize=20)
plt.ylabel("Total Emissions (Kg CO2e)", fontsize=20)
plt.title("Total Emissions per Iteration for Each Scenario", fontsize=20, fontweight="bold")

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.grid(True, linestyle="--", alpha=0.6)
plt.legend(fontsize=12)
plt.tight_layout()
plt.show()

data = {
    "Scenario": [],
    "Emissions": [],
    "Costs": []
}

from openpyxl import load_workbook
import pandas as pd

# Crear datos del escenario
for scenario, values in all_scenarios.items():
    data["Scenario"].append(scenario)
    data["Emissions"].append(values["emissions"])
    data["Costs"].append(values["costs"])

df = pd.DataFrame(data)

# Ruta del archivo
file_path = 'C:/Users/agusv/Desktop/Estudio/Tesis/Csv/Excel_Files/E_Constraint_Simulation_Scenarios.xlsx'

# Intentar escribir en el archivo Excel
try:
    # Si el archivo existe, usa if_sheet_exists='replace' para reemplazar la hoja si ya existe
    with pd.ExcelWriter(file_path, engine='openpyxl', mode='a', if_sheet_exists='replace') as writer:
        df.to_excel(writer, sheet_name='All Scenarios', index=False)
except FileNotFoundError:
    # Si el archivo no existe, crear uno nuevo
    with pd.ExcelWriter(file_path, engine='openpyxl') as writer:
        df.to_excel(writer, sheet_name='All Scenarios', index=False)

